# log out bitlbee on quit, useful when you use an irc proxy such as bip.

use Irssi;
use Irssi::Irc;
use strict;

use vars qw($VERSION %IRSSI);

$VERSION = "0.01";
%IRSSI = (
    authors     => 'Francois Lallart',
    contact     => 'fraff@free.fr',
    name        => 'blquit',
    description => 'logout all bitlbee accounts on quit',
    license     => 'GPLv2',
);

my $name = "&bitlbee";
my $chan;

sub bl_quit {
    my ($data, $server, $channel) = @_;

    foreach my $sv (Irssi::servers()) {
        $chan = $sv->channel_find($name);

        if ($chan) {
            $sv->send_message ($chan->{"name"}, "account off all", 0);
        }
    }
}


Irssi::command_bind('quit', 'bl_quit');
